// $Id: CRolloverButton.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CRolloverButton.hpp"
using Exponent::GUI::Controls::CRolloverButton;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CRolloverButton, CControl);

//	===========================================================================
CRolloverButton::CRolloverButton(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
			   : CControl(root, uniqueId, area, listener)
			   , m_downImage(NULL)
			   , m_overImage(NULL)
			   , m_state(e_mouseOff)
			   , m_cursorChange(true)
			   , m_mouseIsDown(false)

{
	EXPONENT_CLASS_CONSTRUCTION(CRolloverButton);
}

//	===========================================================================
CRolloverButton::~CRolloverButton()
{
	EXPONENT_CLASS_DESTRUCTION(CRolloverButton);
	FORGET_COUNTED_OBJECT(m_downImage);
	FORGET_COUNTED_OBJECT(m_overImage);
}

//	===========================================================================
void CRolloverButton::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	switch(m_state)
	{
		case e_mouseOff:
			if (m_primaryImage)
			{
				graphics.drawImage(m_primaryImage, m_normalisedArea, m_primaryImage->getNormalisedImageSize());
			}
			else
			{
				graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_RED);
				graphics.fillRectangle(m_normalisedArea);

				graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_BLACK);
				graphics.drawRectangle(m_normalisedArea);

				graphics.setTextColour(CAlphaColour::CALPHACOLOUR_BLACK);
				graphics.drawText(m_labelText, m_normalisedArea, CFont::CFONT_SYSTEM_FONT, CGraphics::e_defaultSingleLine);
			}
		break;
		case e_mouseOver:
			if (m_overImage)
			{
				graphics.drawImage(m_overImage, m_normalisedArea, m_overImage->getNormalisedImageSize());
			}
			else
			{
				graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_ORANGE);
				graphics.fillRectangle(m_normalisedArea);

				graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_BLACK);
				graphics.drawRectangle(m_normalisedArea);

				graphics.setTextColour(CAlphaColour::CALPHACOLOUR_BLACK);
				graphics.drawText(m_labelText, m_normalisedArea, CFont::CFONT_SYSTEM_FONT, CGraphics::e_defaultSingleLine);
			}
		break;
		case e_mouseDown:
			if (m_downImage)
			{
				graphics.drawImage(m_downImage, m_normalisedArea, m_downImage->getNormalisedImageSize());
			}
			else
			{
				graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_GREEN);
				graphics.fillRectangle(m_normalisedArea);

				graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_BLACK);
				graphics.drawRectangle(m_normalisedArea);

				graphics.setTextColour(CAlphaColour::CALPHACOLOUR_BLACK);
				graphics.drawText(m_labelText, m_normalisedArea, CFont::CFONT_SYSTEM_FONT, CGraphics::e_defaultSingleLine);
			}
		break;
	}
}

//	===========================================================================
void CRolloverButton::handleLeftButtonDown(CMouseEvent &event)
{
	if (m_cursorChange)
	{
		event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
	}
	m_rootControl->lockControl(this);
	m_state		  = e_mouseDown;
	m_mouseIsDown = true;
	this->update();
}

//	===========================================================================
void CRolloverButton::handleLeftButtonUp(CMouseEvent &event)
{
	if (m_normalisedArea.pointIsInside(event.getMousePosition()))
	{
		if (m_cursorChange)
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
		}
		m_state = e_mouseOver;
	}
	else
	{
		if (m_cursorChange)
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_ARROW);
		}
		m_state = e_mouseOff;
	}
	m_mouseIsDown = false;
	m_rootControl->unlockControl();
	this->update();
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CRolloverButton::handleMouseMovement(CMouseEvent &event)
{
	if (m_mouseIsDown)
	{
		// Then we need to check the areas
		if (m_normalisedArea.pointIsInside(event.getMousePosition()))
		{
			if (m_cursorChange)
			{
				event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
			}
			m_rootControl->lockControl(this);
			m_state		  = e_mouseDown;
			m_mouseIsDown = true;
		}
		else
		{
			// They are outside the area. De lock, unlock button etc
			//m_rootControl->unlockControl();
			m_state       = e_mouseOff;
			m_mouseIsDown = false;
		}
	}
	else
	{
		if (m_normalisedArea.pointIsInside(event.getMousePosition()))
		{
			if (m_cursorChange)
			{
				event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
			}
			m_rootControl->lockControl(this);
			m_state = e_mouseOver;
		}
		else
		{
			if (m_cursorChange)
			{
				event.getMutableMouse()->setCursor(&CCursor::CCURSOR_ARROW);
			}
			m_rootControl->unlockControl();
			m_state = e_mouseOff;
		}
	}
	this->update();
}

//	===========================================================================
void CRolloverButton::handleMouseLeavingArea(CMouseEvent &event)
{
	m_state		  = e_mouseOff;
	m_mouseIsDown = false;
	this->update();
}

//	===========================================================================
void CRolloverButton::setDownImage(IImage *theImage)
{
	EXCHANGE_COUNTED_OBJECTS(m_downImage, theImage);
}

//	===========================================================================
void CRolloverButton::setOverImage(IImage *theImage)
{
	EXCHANGE_COUNTED_OBJECTS(m_overImage, theImage);
}